<?php
// Database connection
$host = 'localhost';
$dbname = 'user_profiles';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);  
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Get the profile link from the URL
if (isset($_GET['link'])) {
    $profile_link = $_GET['link'];

    // Fetch user data from the database
    $stmt = $pdo->prepare("SELECT * FROM users WHERE profile_link = :profile_link");
    $stmt->execute([':profile_link' => $profile_link]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>User Profile</title>
            <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
            <style>
                /* Global Styles */
                body {
                    font-family: 'Poppins', sans-serif;
                    background-color: #f7f7f7;
                    margin: 0;
                    padding: 0;
                    box-sizing: border-box;
                }

                h1, h2 {
                    font-size: 3rem;
                    text-align: center;
                    margin-top: 20px;
                    color: #333;
                }

                /* User Details Styling */
                .user-details {
                    background-color: white;
                    padding: 20px;
                    margin: 10px;
                    border-radius: 8px;
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
                    max-width: 900px;
                    margin: 20px auto;
                }

                .user-details h2 {
                    font-size: 2rem;
                    margin-bottom: 10px;
                }

                .user-details p {
                    font-size: 1.2rem;
                    color: #333;
                    margin: 10px 0;
                }

                /* Icons */
                .user-details i {
                    color: #0066cc;
                    margin-right: 10px;
                }

                /* Mobile and Tablet Responsive Styles */
                @media (max-width: 768px) {
                    h1, h2 {
                        font-size: 1.8rem;
                    }

                    .user-details {
                        padding: 15px;
                        margin: 10px;
                    }

                    .user-details p {
                        font-size: 1rem;
                    }

                    .user-details i {
                        font-size: 1.2rem;
                    }
                }

                @media (max-width: 480px) {
                    h1, h2 {
                        font-size: 1.5rem;
                    }

                    .user-details {
                        padding: 10px;
                        margin: 5px;
                    }

                    .user-details p {
                        font-size: 0.9rem;
                    }

                    .user-details i {
                        font-size: 1rem;
                    }
                }

                /* Slideshow Styles */
                .slideshow-container {
                    max-width: 1000px;
                    position: relative;
                    margin: auto;
                }

                .mySlides2 {
                    display: none;
                }

                .prev, .next {
                    cursor: pointer;
                    position: absolute;
                    top: 50%;
                    width: auto;
                    padding: 16px;
                    margin-top: -22px;
                    color: white;
                    font-weight: bold;
                    font-size: 18px;
                    transition: 0.6s ease;
                    border-radius: 0 3px 3px 0;
                    user-select: none;
                }

                .next {
                    right: 0;
                    border-radius: 3px 0 0 3px;
                }

                .prev:hover, .next:hover {
                    background-color: #f1f1f1;
                    color: black;
                }

                /* Animations */
                @keyframes fadeIn {
                    0% { opacity: 0; }
                    100% { opacity: 1; }
                }

                @keyframes slideUp {
                    0% { transform: translateY(30px); opacity: 0; }
                    100% { transform: translateY(0); opacity: 1; }
                }
            </style>
        </head>
        <body>
            <div class="user-details">
                <h3>B&S #</h3>
                <p><i class="fas fa-map-marker-alt"></i> Rathnapura Road, Udagama, Embilipitiya<br>
                <i class="fas fa-phone-alt"></i> Tel: #</p>
                <p>Dear <?= htmlspecialchars($user['customer_name']) ?>,Your Vehicle Information and Daily Updates!</p>
            </div>



                <div class="user-details">
                    <h3>Customer Profile Information</h3>
                    <p><strong>Customer Name:</strong> <?= htmlspecialchars($user['customer_name']) ?></p>
                    <p><strong>Registration No:</strong> <?= htmlspecialchars($user['registration_no']) ?></p>
                    <p><strong>Mileage:</strong> <?= htmlspecialchars($user['mileage']) ?></p>
                    <hr>
                    <h3>Vehicle Information</h3>
                    <?php
                    $fields = [
                        'battery', 'keys_intelligent_key', 'remote', 'horn', 'cigar_lighter', 'cover_power_outlet', 'washer_nipples', 'original_carpets', 'wiper_blades', 'wiper_arms', 'model_make_badges', 'lights_head', 'lights_parking', 'lights_signal', 'lights_reverse', 'number_plates', 'fogs', 'fender', 'hood', 'brake_high_mounted_stop_light', 'fuel_tank_cap', 'wheels_alloy', 'wheels_steel', 'wheels_std', 'full_wheel_covers', 'wheel_center_caps', 'inside_mirror', 'mud_flaps', 'side_mirrors_power', 'side_mirrors_manual', 'side_mirrors_retractable', 'body_moldings', 'radio', 'cassette', 'cd_player', 'cd_changer', 'usb', 'mp3', 'dicky_board', 'carpet', 'dvd', 'remote_control', 'hydraulic_jack', 'mechanical', 'screen', 'monitor', 'spanners', 'pliers', 'speaker', 'spare_wheel', 'ash_tray', 'door_lock_knobs', 'handle', 'wheel', 'fuse_box', 'cover', 'mats', 'sun_visor', 'vanity_mirrors', 'reverse_sensors'
                    ];

                    foreach ($fields as $field) :
                        $value = isset($user[$field]) ? $user[$field] : 'No'; ?>
                        <p><strong><?= ucfirst(str_replace('_', ' ', $field)) ?>:</strong> <?= htmlspecialchars($value) ?></p>
                    <?php endforeach; ?>
                </div>
            </div>

            <script>
                let slideIndex = 1;
                showSlides(slideIndex);

                function plusSlides(n) {
                    showSlides(slideIndex += n);
                }

                function showSlides(n) {
                    let slides = document.getElementsByClassName("mySlides2");
                    if (n > slides.length) {slideIndex = 1}    
                    if (n < 1) {slideIndex = slides.length}
                    for (let i = 0; i < slides.length; i++) {
                        slides[i].style.display = "none";  
                    }
                    slides[slideIndex-1].style.display = "block";  
                }
            </script>
        </body>
        </html>
        <?php
    } else {
        echo "Profile not found.";
    }
} else {
    echo "Invalid profile link.";
}
?>
